-- Helper Functions for CAT macroscripts

-----------------------------------------------------------------------------------------------
-- function: GetCATNodeGroup
-- Does: Finds the group (data) controller of the passed node, if it exists
-- Arguments: aNode a node to search.
-- Returns: The group controller of the node.
-----------------------------------------------------------------------------------------------	
fn GetCATNodeGroup aNode = 
(
	local catctrl = aNode.controller
	
	catctrl = case (classof catctrl) of
	(
		CATBoneSegTrans:	( catctrl = catctrl.bonedata.limb; )
		CollarboneTrans:		( catctrl = catctrl.Limb; )
		CATDigitSegTrans:	( catctrl = catctrl.digitdata.controller; )
		TailTrans:		( catctrl = catctrl.taildata;  )
		default:			( catctrl; )
	)
	
	catctrl;
)

-----------------------------------------------------------------------------------------------
-- function: GetCatParent 	
-- Does: Finds the CATParent of passed node or controller, if it is part of a CAT character
-- Arguments: aNodeOrController Either a node or controller to search.
-- Returns: CATparent found, or undefined if not a member of a CAT character
-----------------------------------------------------------------------------------------------	
fn GetCATParent aNodeOrController = 
(
	res = undefined;
	ctrl = aNodeOrController;
	if (iskindof aNodeOrController Node) then ctrl = aNodeOrController.controller

	if (ctrl != undefined) then (
		if ((GetInterface ctrl "ICATControlFPInterface") != undefined) then (res = ctrl.catparent)
		else if (classof ctrl == CATParentTrans) do (res = ctrl.node.baseobject)
	)
	res;
)

function GetSelectedSubAnim subAnimIndex = 
(
	result = undefined
	if selection.count == 1 then 
	(
		local selObj = selection[1]
		if (selObj.numSubs >= subAnimIndex) then
		(
			result = GetSubAnim selObj subAnimIndex
		)
	)
	result
)

function GetSelectedCATParent = 
(
	result = undefined
	local selSubAnim = GetSelectedSubAnim 3
	if (selSubAnim != undefined) then
	(
		result = GetCATParent selSubAnim;
	)
	result
)
function SelectionHasCATParent = 
(
	result = false
	local cparent = GetSelectedCATParent()
	if (cparent != undefined) then
	(
		result = true
	)
	result
)

function CATParentSetupMode = 
(
	result = false
	local selCatParent = GetSelectedCATParent()
	if (selCatParent != undefined) then
	(
		if( selCatParent.catmode == 0 ) then 
			result = true;
	)
	result
)

function IsSelectionSubAnimClassOf classType = 
(
	result = false
	if selection.count == 1 then 
	(
		local selObj = selection[1]
		if (selObj.numSubs >= 3) then
		(
			local selSubAnim = GetSubAnim selObj 3
			if (selSubAnim != undefined) then
			(
				if (hasproperty selSubAnim "CatParent") then
				(
					if(classof selSubAnim.controller) == classType then 
						result = true;
				)
			)
		)
	)
	result
)

function DoesSelectedContainInterface interfaceName = 
(
	local result = false
	for obj in selection while result == false do
	(
		if (getinterface obj[3] interfaceName) != undefined then
		(
			result = true;
		)
	)
	result	
)

function IsFloatController v = 
(
	isValid = (isProperty v.anim #value) and (classof v.anim.value == Float) and (isPropertyAnimatable v.client v.name)
	isValid
)

function IsCATEntity v = ( res = (GetCATParent v != undefined); res )

-- Global shut down utility function for CAT
function CAT_OnMaxShutdown =
(
	unregisterSelectFilterCallback IsCATEntity
	unregisterDisplayFilterCallback IsCATEntity
	callbacks.RemoveScripts id: #CATUtils
)

-- Global startup utility function for CAT
function CAT_OnMaxStartup = 
(
	-- Register a display filter to display only CATEntities
	registerSelectFilterCallback IsCATEntity ~SELECT_FILTER_CALL_CATENTITY_NAME~
	registerDisplayFilterCallback IsCATEntity ~DISPLAY_FILTER_CALL_CATENTITY_NAME~
	-- Failing to unregister these callbacks will result in a memory leak. Thus we have to register a callback to do that
	-- when max quits
	callbacks.RemoveScripts id: #CATUtils -- Attempt to remove the old one if the script is re-evaluated
	callbacks.AddScript #preSystemShutdown "CAT_OnMaxShutdown()" id: #CATUtils
)
CAT_OnMaxStartup();